/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.LinkLayerCompTest;

import com.quantumdata.LinkLayerCompTest.DPBasePanel;
import com.quantumdata.LinkLayerCompTest.llctGui;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class DPVideoTimingsPanel
extends QDPanel {
    private static final long serialVersionUID = 111922830111922830L;
    private static final int[] sVESAHorizontal = new int[]{2560, 2048, 1920, 1792, 1680, 1600, 1600, 1440, 1400, 1360, 1280, 1280, 1280, 1280, 1280, 1280, 1024, 848, 800, 800};
    private static final int[] sVESAVertical = new int[]{1600, 1536, 1200, 1344, 1050, 1200, 1200, 900, 1050, 768, 1024, 960, 800, 800, 768, 768, 768, 480, 600, 600};
    private static final int[] sVESARefreshRates = new int[]{60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 75};
    private static final boolean[] sVESAProgressive = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] sVESAReduced = new boolean[]{true, true, true, false, false, false, true, false, true, false, false, false, false, true, false, true, false, false, false, false};
    private static final int[] sCEAHorizontal = new int[]{1920, 1920, 1920, 1920, 1440, 1440, 1280, 720};
    private static final int[] sCEAVertical = new int[]{1080, 1080, 1080, 1080, 480, 576, 720, 480};
    private static final double[] sCEARefreshRates = new double[]{60.0, 50.0, 59.94, 60.0, 59.94, 50.0, 60.0, 60.0};
    private static final boolean[] sCEAProgressive = new boolean[]{true, false, false, false, true, true, true, true};
    private JList aVESATimingsList;
    private JList aCEATimingsList;
    private JComboBox aMaxBitsPerComponent;
    private llctGui mainWin;

    public DPVideoTimingsPanel(llctGui llctGui2) {
        int n;
        this.mainWin = llctGui2;
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Video Timings / Color Formats"));
        String[] stringArray = new String[sVESAHorizontal.length];
        String[] stringArray2 = new String[sCEAHorizontal.length];
        for (n = 0; n < sVESAHorizontal.length; ++n) {
            stringArray[n] = "" + sVESAHorizontal[n] + "x" + sVESAVertical[n] + (sVESAProgressive[n] ? "p" : "i") + " @ " + sVESARefreshRates[n] + "Hz";
            if (!sVESAReduced[n]) continue;
            int n2 = n;
            stringArray[n2] = stringArray[n2] + "(Reduced)";
        }
        for (n = 0; n < sCEAHorizontal.length; ++n) {
            stringArray2[n] = "" + sCEAHorizontal[n] + "x" + sCEAVertical[n] + (sCEAProgressive[n] ? "p" : "i") + " @ " + sCEARefreshRates[n] + "Hz";
        }
        this.aVESATimingsList = new JList<String>(stringArray);
        this.aVESATimingsList.setVisibleRowCount(3);
        this.aVESATimingsList.setSelectionMode(2);
        JScrollPane jScrollPane = new JScrollPane(this.aVESATimingsList);
        this.aCEATimingsList = new JList<String>(stringArray2);
        this.aCEATimingsList.setVisibleRowCount(3);
        this.aCEATimingsList.setSelectionMode(2);
        JScrollPane jScrollPane2 = new JScrollPane(this.aCEATimingsList);
        this.aMaxBitsPerComponent = new JComboBox();
        this.aMaxBitsPerComponent.addItem("6");
        this.aMaxBitsPerComponent.addItem("8");
        this.aMaxBitsPerComponent.addItem("10");
        this.aMaxBitsPerComponent.addItem("12");
        this.aMaxBitsPerComponent.addItem("16");
        int n3 = 0;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        QDPanel qDPanel = new QDPanel(gridBagLayout);
        QDLabel qDLabel = new QDLabel("VESA Timings List:");
        gridBagConstraints = DPBasePanel.createGridBagConstraints(1, 0, n3, 3, 22);
        gridBagLayout.setConstraints(qDLabel, gridBagConstraints);
        qDPanel.add(qDLabel);
        gridBagConstraints = DPBasePanel.createGridBagConstraints(5, 1, n3++, 3, 21);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        qDPanel.add(jScrollPane);
        QDLabel qDLabel2 = new QDLabel("CEA Timings List:");
        gridBagConstraints = DPBasePanel.createGridBagConstraints(1, 0, n3, 3, 22);
        gridBagLayout.setConstraints(qDLabel2, gridBagConstraints);
        qDPanel.add(qDLabel2);
        gridBagConstraints = DPBasePanel.createGridBagConstraints(3, 1, n3++, 3, 21);
        gridBagLayout.setConstraints(jScrollPane2, gridBagConstraints);
        qDPanel.add(jScrollPane2);
        QDLabel qDLabel3 = new QDLabel("Max Bits Per Component:");
        gridBagConstraints = DPBasePanel.createGridBagConstraints(1, 0, n3, 3, 22);
        gridBagLayout.setConstraints(qDLabel3, gridBagConstraints);
        qDPanel.add(qDLabel3);
        gridBagConstraints = DPBasePanel.createGridBagConstraints(1, 1, n3++, 3, 21);
        gridBagLayout.setConstraints(this.aMaxBitsPerComponent, gridBagConstraints);
        qDPanel.add(this.aMaxBitsPerComponent);
        this.add((Component)qDPanel, "Center");
    }

    public void reset() {
        this.aMaxBitsPerComponent.setSelectedIndex(0);
    }

    public String[] GetVESATimings() {
        return null;
    }

    public String[] GetCEATimings() {
        return null;
    }

    public int GetMaximumBitsPerComponent() {
        int n = 6;
        String string = (String)this.aMaxBitsPerComponent.getSelectedItem();
        n = new Integer(string);
        return n;
    }

    public void UpdateStatus(String string) {
        int n = 0;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        try {
            int n2;
            Object object;
            String string2 = string + ":lltm?";
            String string3 = this.mainWin.sendCmd(string2);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string4;
                int n3;
                String string5;
                object = stringTokenizer.nextToken();
                if (((String)object).length() < 3) continue;
                String string6 = ((String)object).substring(0, 3);
                if (string6.equalsIgnoreCase("CVT") || string6.equalsIgnoreCase("DMT")) {
                    string5 = DPVideoTimingsPanel.StripAllSpaces(((String)object).replaceFirst(string6, "").trim());
                    for (n3 = 0; n3 < this.aVESATimingsList.getModel().getSize(); ++n3) {
                        string4 = DPVideoTimingsPanel.StripAllSpaces((String)this.aVESATimingsList.getModel().getElementAt(n3));
                        if (!string4.equalsIgnoreCase(string5)) continue;
                        vector.add(new Integer(n3));
                    }
                    continue;
                }
                if (!string6.equalsIgnoreCase("CEA")) continue;
                string5 = DPVideoTimingsPanel.StripAllSpaces(((String)object).replaceFirst(string6, "").trim());
                for (n3 = 0; n3 < this.aCEATimingsList.getModel().getSize(); ++n3) {
                    boolean bl;
                    string4 = DPVideoTimingsPanel.StripAllSpaces((String)this.aCEATimingsList.getModel().getElementAt(n3));
                    boolean bl2 = DPVideoTimingsPanel.ParseHorizontalResolution(string5) == DPVideoTimingsPanel.ParseHorizontalResolution(string4);
                    boolean bl3 = DPVideoTimingsPanel.ParseVerticalResolution(string5) == DPVideoTimingsPanel.ParseVerticalResolution(string4);
                    boolean bl4 = DPVideoTimingsPanel.ParseRefreshRate(string5) == DPVideoTimingsPanel.ParseRefreshRate(string4);
                    boolean bl5 = DPVideoTimingsPanel.ParseProgressiveFlag(string5) == DPVideoTimingsPanel.ParseProgressiveFlag(string4);
                    boolean bl6 = bl = DPVideoTimingsPanel.ParseFormatField(string5) == DPVideoTimingsPanel.ParseFormatField(string4);
                    if (!bl2 || !bl3 || !bl4 || !bl5 || !bl) continue;
                    vector2.add(new Integer(n3));
                }
            }
            object = new int[vector.size()];
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = (Integer)vector.get(i);
            }
            this.aVESATimingsList.setSelectedIndices((int[])object);
            int[] nArray = new int[vector2.size()];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = (Integer)vector2.get(n2);
            }
            this.aCEATimingsList.setSelectedIndices(nArray);
            n = this.mainWin.getInt(string + ":llmc?");
            for (n2 = 0; n2 < this.aMaxBitsPerComponent.getItemCount(); ++n2) {
                if (n != Integer.parseInt((String)this.aMaxBitsPerComponent.getItemAt(n2))) continue;
                this.aMaxBitsPerComponent.setSelectedIndex(n2);
                break;
            }
        }
        catch (InstrumentException instrumentException) {
            System.out.println(instrumentException.toString());
        }
    }

    public void SendBackStatus(String string) {
        try {
            String string2;
            int n;
            this.mainWin.sendCmd(string + ":trst");
            int[] nArray = this.aVESATimingsList.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                n = nArray[i];
                string2 = string + ":lltm " + sVESAHorizontal[n] + " " + sVESAVertical[n] + " " + sVESARefreshRates[n] + " " + (sVESAProgressive[n] ? "0" : "1") + " 1 " + (sVESAReduced[n] ? "1" : "0");
                this.mainWin.sendCmd(string2);
            }
            int[] nArray2 = this.aCEATimingsList.getSelectedIndices();
            for (int i = 0; i < nArray2.length; ++i) {
                n = nArray2[i];
                string2 = string + ":lltm " + sCEAHorizontal[n] + " " + sCEAVertical[n] + " " + sCEARefreshRates[n] + " " + (sCEAProgressive[n] ? "0" : "1") + " 0 0";
                this.mainWin.sendCmd(string2);
            }
            if (string.equalsIgnoreCase("dprx")) {
                if (nArray.length > 0) {
                    n = nArray[0];
                    string2 = string + ":lled " + sVESAHorizontal[n] + " " + sVESAVertical[n] + " " + sVESARefreshRates[n] + " " + (sVESAProgressive[n] ? "0" : "1") + " 1 " + (sVESAReduced[n] ? "1" : "0");
                    this.mainWin.sendCmd(string2);
                } else if (nArray2.length > 0) {
                    n = nArray2[0];
                    string2 = string + ":lled " + sCEAHorizontal[n] + " " + sCEAVertical[n] + " " + sCEARefreshRates[n] + " " + (sCEAProgressive[n] ? "0" : "1") + " 0 0";
                    this.mainWin.sendCmd(string2);
                }
            }
            this.mainWin.sendCmd(string + ":llmc " + (String)this.aMaxBitsPerComponent.getSelectedItem());
        }
        catch (InstrumentException instrumentException) {
            System.out.println(instrumentException.toString());
        }
    }

    public static int ParseHorizontalResolution(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "x");
        if (stringTokenizer.countTokens() >= 1) {
            try {
                n = new Integer(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        return n;
    }

    public static int ParseVerticalResolution(String string) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("x");
        if (DPVideoTimingsPanel.ParseProgressiveFlag(string)) {
            stringBuffer.append("p");
        } else {
            stringBuffer.append("i@");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, stringBuffer.toString());
        if (stringTokenizer.countTokens() >= 2) {
            stringTokenizer.nextToken();
            try {
                n = new Integer(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        return n;
    }

    public static double ParseRefreshRate(String string) {
        double d = 0.0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "@H");
        if (stringTokenizer.countTokens() >= 3) {
            stringTokenizer.nextToken();
            try {
                d = new Double(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.0;
            }
        }
        return d;
    }

    public static boolean ParseProgressiveFlag(String string) {
        String string2;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "@");
        if (stringTokenizer.countTokens() >= 2 && (string2 = stringTokenizer.nextToken()).endsWith("p")) {
            bl = true;
        }
        return bl;
    }

    public static boolean ParseFormatField(String string) {
        boolean bl = false;
        if (string.endsWith("(Reduced)")) {
            bl = true;
        }
        return bl;
    }

    public static String StripAllSpaces(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }
}

